from scapy.all import rdpcap
from scapy.layers.inet import ICMP
from scapy.layers.inet import IP

packets = rdpcap("icmp.pcap")

print ('Nombre de paquets dans la capture:',len(packets))

nbPackets = 0
nbRequetesEcho = 0
nbReponsesEcho = 0
        
for packet in packets:				# Boucle pour tous les paquets
    if packet.haslayer(ICMP):		# ICMP?
        nbPackets+=1
        if packet[ICMP].type == 8:  # Request
            print ('Requete ECHO', packet[IP].src, packet[IP].dst)
            nbRequetesEcho+=1			
        elif packet[ICMP].type == 0:#Reply                    
            print ('Reponse ECHO', packet[IP].src, packet[IP].dst)
            nbReponsesEcho+=1

print ('Nombre de paquets ICMP:', nbPackets)
print ('Nombre de requetes Echo:', nbRequetesEcho)
print ('Nombre de reponses Echo:', nbReponsesEcho)