## Tout importer
## from scapy.all import *

## importation de rdpcap
from scapy.all import rdpcap

## importation de protocole
from scapy.all import ARP
from scapy.all import Ether
from scapy.all import IP
from scapy.all import TCP
## autres sous librairies 
from scapy.all import sniff
from scapy.all import send
from scapy.all import sendp

## Mode passif lecture
def passive_capture():
    
    filename = "intro_scapy.pcap"
    packets = rdpcap(filename)

    ## on passe au travers du script
    for packet in packets:
        ## packet.show()
        if packet.haslayer(ARP): ## Vérifier si le paquet contient une couche particulière
            print (packet[ARP]) ## Obtenir une couche particulière
            
            print (packet[ARP].op) ## Manipuler les champs d’une couche particulière
            print (packet[ARP].hwsrc) ## Manipuler les champs d’une couche particulière

## Mode Actif lecture
def active_capture(): 
    ## Pour capturer le trafic, on utilise la fonction sniff():
    ##################################################################################
    sniff(filter='port 53')
    ## a = sniff(filter='tcp')
    ## a = sniff(filter='tcp port 80')

    ## Avec une fonction (expression lambda):
    ##################################################################################
    ## a = sniff(prn=fonction_arp)
    ## a = sniff(prn=fonction_ip_filter)
    ## a = sniff(prn=fonction_spoof_dns)

    ## Options pour la fonction sniff():
    ##################################################################################
    ## a = sniff(iface='eth0')
    ## a = sniff(prn=fonction_ip_filter, count=0)
    ## a = sniff(prn=fonction_spoof_dns, store=0)

    ## Pour créer un paquet avec des valeurs définies:
    ##################################################################################
    ## value = 'AA:AA:AA:AA:AA:AA'

    packet = Ether(dst='FF:FF:FF:FF:FF:FF')
    ## packet = ARP(psrc='172.16.0.12')
    ## packet = IP(dst=value) ##où value est une variable
    ## packet = TCP(flag=0x11)

    ## On peut aussi ‘empiler’ les couches d’un paquet, pour ajuster les valeurs de plusieurs couches:
    ##################################################################################
    ## packet = Ether(dst='FF:FF:FF:FF:FF:FF')/ARP(psrc='172.16.0.12')
    ## packet = IP(dst=value)/TCP(flag=0x11)

    print (packet)

    ## Option ‘loop’:  Si 0, le paquet est envoyé 1 fois, 		sinon envoyé à l’infini
    ## Option ‘inter’: intervalle, en secondes, avant 			d’envoyer le prochain paquet
    ##################################################################################
    ## a = IP(dst='FF:FF:FF:FF:FF:FF', ttl=1)/TCP(flag=0x11)
    ## send(a, loop=0, inter=2)

    ## Option ‘iface’:  Interface sur laquelle le paquet sera envoyé
    
    ## a = Ether(src='12:12:12:34:34:34')/IP(dst='FF:FF:FF:FF:FF:FF', ttl=1)	
    ## sendp(a, iface='eth0', loop=0, inter=2)


passive_capture()
## active_capture()